-- Grundfunktionalitäten (nummer from id, Sprachen usw)

 CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__k_nummer__from__k_id(kid INTEGER) RETURNS VARCHAR(100) AS $$
    SELECT k_nummer FROM TSystem_Wawi.beleg_k WHERE k_id = kid;
    $$ LANGUAGE SQL STABLE;
 CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__k_nummer__from__p_id(pid INTEGER) RETURNS VARCHAR(100) AS $$
    SELECT TSystem_Wawi.beleg_k__k_nummer__from__k_id(p_k_id) FROM tsystem_wawi.beleg_p WHERE p_id = pid;
    $$ LANGUAGE SQL STABLE;
 CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__p_pos__from__p_id(pid INTEGER) RETURNS INTEGER AS $$
    SELECT p_pos FROM TSystem_Wawi.beleg_p WHERE p_id = pid;
    $$ LANGUAGE SQL STABLE;
 CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__k_nummer__erstelldatum__from__p_id(IN pid INTEGER, OUT dokunr VARCHAR, OUT erstelldatum DATE) RETURNS RECORD AS $$
    SELECT k_nummer, k_erfasst_datum /*INTO dokunr, erstelldatum*/ FROM TSystem_Wawi.beleg_k JOIN TSystem_Wawi.beleg_p ON k_id = p_k_id WHERE p_id = pid;
    $$ LANGUAGE SQL STABLE;

 -- TODO Grundfunktino Mehrsprachigkeit (lang_belart) #13109

--
-- Mengen Aktualisierungen: RechnungV > LieferscheinV > Verkauf Mengen Geliefert, Fakturiert
 CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(IN in_verkauf__p_id INTEGER, OUT mengel_gme NUMERIC, OUT mengef_gme NUMERIC) AS $$
   DECLARE lifsch__sumstkl                              NUMERIC(12,4);
           beleg_p__lieferschein__sum_mengel            NUMERIC(12,4);
           beleg_p__rechnungv__sum_mengef               NUMERIC(12,4);
           beleg_p__lieferschein__sum_mengel_storno     NUMERIC(12,4);
   BEGIN
     IF in_verkauf__p_id IS NULL THEN
         RETURN;
     END IF;

     -- Summe der Lagerabgänge für den Auftrag.
     SELECT COALESCE( SUM(COALESCE(l_abgg_uf1, 0)),0) INTO lifsch__sumstkl
       FROM lifsch WHERE l_ag_id = in_verkauf__p_id AND l_bz_id IS NULL; -- LA sind aus Auftrag und keiner Rechnung (auf Konsi-LFS) zugeordnet, siehe #8093.

     -- Summe die direkt aus Auftrag in Lieferscheindokument übernommen wurde. Es darf also keinen Lagerabgang auf den Auftrags geben.
     SELECT COALESCE( SUM(COALESCE(IFTHEN(beld_belegart = 10, -1, 1) * p_menge_gme, 0)),0) INTO beleg_p__lieferschein__sum_mengel  --- #18674 beld_belegart = 10 Stornolieferscheine, Minus-Menge
       FROM TWawi.beleg_p__lieferscheinv
         LEFT JOIN belegdokument ON beld_id = p_k_id
       WHERE plv_verkauf_p_id = in_verkauf__p_id
        AND NOT EXISTS (SELECT true FROM lifsch WHERE l_ag_id = in_verkauf__p_id);

     /* Alte Version (vor 10/2017) - Da gab es unter ganz bestimmten Umständen ein Reihenfolgeproblem beim Rahmenabruf. => http://redmine.prodat-sql.de/issues/8277      
        SELECT SUM(COALESCE(belp_menge_gme, 0)) INTO stklbelpos FROM belegpos LEFT JOIN lifsch ON l_belp_id = belp_id WHERE belp_ag_id = agid AND belp_belegtyp = 'LFS' AND l_ag_id IS NULL;      
     */       
     
     -- Verrechnete Menge aus Auftrag in Rechnungen
     SELECT SUM(COALESCE(p_menge_gme - COALESCE(gutschriften.sum_p_menge_gme, 0), 0)) INTO beleg_p__rechnungv__sum_mengef
       FROM TWawi.beleg_p__rechnungv rv_p
         JOIN TWawi.beleg_k__rechnungv rv_k ON rv_k.k_id = rv_p.p_k_id
         JOIN auftg ON ag_id = rv_p.prv_verkauf_p_id, --auftg ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos,
         LATERAL ( -- fakturierte Menge der Gutschriften. Wird abgezogen.
             SELECT SUM(COALESCE(gut_p.p_menge_gme, 0)) AS sum_p_menge_gme
             FROM TWawi.beleg_p__rechnungv AS gut_p
                  JOIN TWawi.beleg_k__rechnungv gut_k ON gut_k.k_id = gut_p.p_k_id
             WHERE gut_k.k_code = 'G'
                   AND gut_p.prv_verkauf_p_id = in_verkauf__p_id -- Summe Alle Gutschriften, die zu meiner Lieferscheinposition erstellt wurden
             ) AS gutschriften
       WHERE rv_k.k_code = 'R'
         AND ag_id = in_verkauf__p_id;

     -- Liefermenge, fakturierte Menge und Auftrag in Auftrag zurückschreiben
     PERFORM disablemodified();
     PERFORM disableauftgtrigger();
     UPDATE auftg SET
         ag_stkl = COALESCE(lifsch__sumstkl, 0) + COALESCE(beleg_p__lieferschein__sum_mengel, 0),
         ag_stkf = COALESCE(beleg_p__rechnungv__sum_mengef, 0),
         ag_done = IFTHEN(COALESCE(lifsch__sumstkl, 0) + COALESCE(beleg_p__lieferschein__sum_mengel, 0) = 0, ag_stk = COALESCE(beleg_p__rechnungv__sum_mengef, 0), ag_done)
         -- Rechnungsposition ohne Lieferschein löschen soll auch den Auftrag wieder öffnen (Auftrag ohne Lieferschein direkt in Rechnung)
         -- Wenn nichts in Lieferschein, dann Prüfen ob alles verrechnet. Sonst so lassen, wie es war.
     WHERE ag_id = in_verkauf__p_id
     RETURNING ag_stkl, ag_stkf INTO mengel_gme, mengef_gme;
     PERFORM enableauftgtrigger();
     PERFORM enablemodified();

     RETURN;
   END $$ LANGUAGE plpgsql;
 -- nächstes TODO TestCase Rechnung und Gutschrift
 CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__lieferscheinv__mengef__refresh(IN in_lieferscheinv__p_id INTEGER, OUT mengef_gme NUMERIC) AS $$
   DECLARE beleg_p__rechnungv__sum_mengef NUMERIC(12,4);
   BEGIN
     IF in_lieferscheinv__p_id IS NULL THEN
         RETURN;
     END IF;
     -- Verrechnete Menge aus Lieferschein in Rechnungen
     SELECT SUM(COALESCE(rv_p.p_menge_gme - COALESCE(gutschriften.sum_p_menge_gme, 0), 0)) INTO beleg_p__rechnungv__sum_mengef
       FROM TWawi.beleg_p__rechnungv rv_p
         JOIN TWawi.beleg_k__rechnungv rv_k ON rv_k.k_id = rv_p.p_k_id
         JOIN TWawi.beleg_p__lieferscheinv lv_p ON lv_p.p_id = rv_p.prv_lieferscheinv_p_id, --auftg ON ag_astat = 'E' AND ag_nr = bz_auftg AND ag_pos = bz_auftgpos,
         LATERAL ( -- fakturierte Menge der Gutschriften. Wird abgezogen.
             SELECT SUM(COALESCE(gut_p.p_menge_gme, 0)) AS sum_p_menge_gme
             FROM TWawi.beleg_p__rechnungv AS gut_p
                  JOIN TWawi.beleg_k__rechnungv gut_k ON gut_k.k_id = gut_p.p_k_id
             WHERE gut_k.k_code = 'G'
                   AND gut_p.prv_lieferscheinv_p_id = in_lieferscheinv__p_id -- Summe Alle Gutschriften, die zu meiner Lieferscheinposition erstellt wurden
             ) AS gutschriften
       WHERE rv_k.k_code = 'R'
         AND lv_p.p_id = in_lieferscheinv__p_id;
     -- Liefermenge, fakturierte Menge und Auftrag in Auftrag zurückschreiben
     PERFORM disablemodified();
     UPDATE TWawi.beleg_p__lieferscheinv SET
         plv_mengef_gme  = COALESCE(beleg_p__rechnungv__sum_mengef, 0),
         p_done          = IfThen( ROUND( COALESCE( beleg_p__rechnungv__sum_mengef, 0), 2)  >= ROUND(p_menge_gme, 2), true, p_done)
         -- Rechnungsposition ohne Lieferschein löschen soll auch den Auftrag wieder öffnen (Auftrag ohne Lieferschein direkt in Rechnung)
         -- Wenn nichts in Lieferschein, dann Prüfen ob alles verrechnet. Sonst so lassen, wie es war.
     WHERE p_id = in_lieferscheinv__p_id
     RETURNING plv_mengef_gme INTO mengef_gme;
     PERFORM enablemodified();

     RETURN;
   END $$ LANGUAGE plpgsql;
 --
--

-- Todo: Funktionen inhalte überspielen in alte Funktion?

--
-- LieferscheinV   >>  Erzeugen Lieferschein aus Vorgänger (Lagerabgang, Auftrag)
 -- Hinweis: diese Funktionen könnten wahrscheinlich noch weiter zusammengefasst werden und zu einer werden, sobald es noch einen normalisierten View auf Lagerabgänge (letzlich auch eine Pos mit Menge usw) gibt
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__lieferscheinv__from__lagerabgang__create(IN lifschdbrid VARCHAR, IN belegdoknr VARCHAR) RETURNS INTEGER AS $$
     DECLARE rec     RECORD;
         docRec     RECORD;
           frei     BOOLEAN;
          belegid   INTEGER;
            docid   INTEGER;
           versart  VARCHAR;

     BEGIN

      SELECT beld_id INTO docid FROM lieferschein WHERE beld_dokunr = belegdoknr;

      -- Belegdokument noch anlegen? Falls es das schon gibt, haengen wir Positionen an.
      IF NOT (docid IS NULL) THEN
        RETURN docid;
      END IF;

      --Gibt es Auftrag zum Lieferschein oder war das vielleicht freier Lagerabgang?
      SELECT (l_ag_id IS NULL) INTO frei FROM lifsch WHERE lifsch.dbrid = lifschdbrid;

      -- Wir sammeln mal alle möglichen Daten im System
      SELECT COALESCE(l_versart,atd_vers,a1_vers) AS versart,
             COALESCE(
                    (SELECT v_id FROM versart WHERE v_art = TRIM(l_versart)),
                    atd_v_id,
                    (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))
                    ) as versartID,
             l_abgg, ag_id, l_krz, l_krzl, l_krzf, atd_ld_auftg, l_ag_id, l_ldat,l_kdat , l_akdat,
             l_an_nr, atd_apkrzl, atd_ap, atd_apint, atd_versandort
          INTO rec
             FROM lifsch    LEFT JOIN adk1 ON a1_krz = l_krz    -- <= Bestelleradresse gibt Versandart vor.
                            LEFT JOIN auftg ON ag_id = l_ag_id
                            LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
             WHERE lifsch.dbrid = lifschdbrid;

      -- Belegdokument anlegen
      INSERT INTO lieferschein (
          beld_dokunr, beld_apkrzl, beld_ap, beld_versandart, beld_versandartbem,
          beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_erstelldatum, beld_refbeleg
          , beld_versandort
       ) VALUES (
          belegdoknr, rec.atd_apkrzl, rec.atd_ap, /*0, 0, 0,*/ rec.versartID, rec.versart,
          rec.l_krz, rec.l_krzl, rec.l_krzf, current_date, rec.atd_ld_auftg --527="Lieferschein"
          , rec.atd_versandort
       ) RETURNING beld_id INTO docid;

      RETURN docid;
     END $$ LANGUAGE plpgsql VOLATILE;
 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__lieferscheinv__from__lagerabgang__create(IN lifschdbrid VARCHAR, IN belegdoknr VARCHAR, IN menge NUMERIC) RETURNS INTEGER AS $$
     DECLARE rec             RECORD;
            docRec          RECORD;
            frei            BOOLEAN;
            addLiefPosID    INTEGER;
            --belegid         INTEGER;
            posid           INTEGER;
            Verrechenbar    BOOLEAN;
            Beistellung     BOOLEAN;
            --uebernommen   NUMERIC;
            --menge_gme     NUMERIC;
            uebernahme      NUMERIC;
            Konsignation    BOOLEAN DEFAULT FALSE; -- ist ein Konsignationsprozess
            MergeLagAbg               BOOLEAN DEFAULT FALSE;   -- Wir dürfen Lagerangänge des gleichen Artikel auf die gleiche Auftragsposition als 1 Lieferscheinposition zusammenfassen
            MergeLagAbg_CheckChnr     BOOLEAN DEFAULT FALSE;      -- ... (nur) wenn die Chargennummer übereinstimmt
            MergeLagAbg_CheckLgOrtUE  BOOLEAN DEFAULT FALSE;      -- ... (nur) wenn sie auf dem gleichen Kommissionierlagerort liegen
     BEGIN

        -- Wir sammeln mal alle möglichen Daten im System
      SELECT ag_akbz AS akbez,
             --Versandart holen, versuchen V_ID zu finden.
             COALESCE(l_versart, atd_vers, a1_vers) AS versart,
             COALESCE((SELECT v_id FROM versart WHERE v_art = TRIM(l_versart)),
                       atd_v_id,
                      (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))) as versartID,
             COALESCE(l_abgg,0) as l_abgg,
             l_abg_mec, l_krz, l_krzl, l_krzf, l_abgg_uf1,
             l_aknr, l_ag_id, l_an_nr, l_ldat, l_kdat, l_akdat,
             l_bda, IFTHEN(TSystem.Settings__GetBool('lifsch_dont_use_auftgtxt'), l_azutx, COALESCE(l_azutx, ag_txt)) AS l_azutx, IFTHEN(TSystem.Settings__GetBool('lifsch_dont_use_auftgtxt'), l_azutx_rtf, COALESCE(l_azutx_rtf, ag_txt_rtf)) AS l_azutx_rtf, ag_postxt, ag_postxt_rtf, l_gew, (TSystem.Settings__Get('BASIS_W')) AS waer,
             l_nr, m_uf, l_lgchnr, l_dofakt,l_lgort_ue,
             ag_bstat, ag_bstat1, ag_bstat2, -- #7895
             ag_stat
             INTO rec
             FROM lifsch    JOIN artmgc ON l_abg_mec = m_id
                            JOIN art ON ak_nr = l_aknr
                            LEFT JOIN adk1 ON a1_krz = l_krz
                            LEFT JOIN auftg ON ag_id = l_ag_id
                            LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
             WHERE lifsch.dbrid = lifschdbrid;

      Konsignation := (TSystem.Enum_GetValue(Rec.ag_bstat, 'K') OR TSystem.Enum_GetValue(Rec.ag_bstat1, 'K') OR TSystem.Enum_GetValue(Rec.ag_bstat2, 'K'));

      IF Konsignation THEN
        -- #10425 Ein Zusammenführen der LA führt zu Problemen, da belzeil_auftg_lif__a_60_iu__konsignationslager nicht mehrer LAs aufteilen kann
        MergeLagAbg := false;
      ELSE
        -- wenn kein Konsignationsprozess, dann so wie immer
        MergeLagAbg := TSystem.Settings__GetBool('MergeLagAbg');
      END IF;

      IF MergeLagAbg THEN
        MergeLagAbg_CheckChnr:=TSystem.Settings__GetBool('MergeLagAbg_CheckChnr');
        MergeLagAbg_CheckLgOrtUE:=TSystem.Settings__GetBool('MergeLagAbg_CheckLgOrtUE');
      END IF;

      SELECT * INTO docRec FROM lieferschein WHERE beld_dokunr = belegdoknr;

      --SELECT bel_id INTO belegid FROM beleg WHERE bel_nummer = belegdoknr AND bel_belegtyp = docRec.Beld_belegtyp;

      -- Satz gefunden, aber kein Auftrag für Lagerabgang? => Freier Lieferschein
      frei:=(rec.l_nr IS NOT NULL) AND (rec.l_ag_id IS NULL);

      -- Beistellung an Lieferant oder durch Kunde?
      Beistellung := TSystem.Enum_GetValue(rec.ag_stat, 'BL') OR TSystem.Enum_GetValue(rec.ag_stat, 'BK');

      -- Die Lieferscheinposition ist verrechenbar, wenn Lagerabgang noch nicht verrechnet ist und es keine Beistellung ist
      Verrechenbar:= (rec.l_dofakt) AND (NOT Beistellung);

      -- Prüfen ob wir den Lagerabgang mit Anderen zu einer Lieferscheinpos. zusammenfassen dürfen / könnten
      addLiefPosID:=NULL;
      IF (NOT frei) AND MergeLagAbg THEN
        SELECT belp_id INTO addLiefPosID
          FROM lieferschein_pos
            JOIN lieferschein ON belp_dokument_id = beld_id
            JOIN lifsch ON belp_id = l_belp_id
          WHERE belp_ag_id    = rec.l_ag_id                         -- ... auf gleiche Auftragsposition
            AND belp_aknr     = rec.l_aknr                          -- ... mit gleichem Artikel
            AND beld_dokunr   = belegdoknr                          -- ... auf dem Lieferschein auf den wir übernehmen sollen
            AND belp_mce      = rec.l_abg_mec                       -- ... und in der gleichen Mengeneinheit
            AND NOT (belp_storniert OR belp_erledigt)               -- ... die weder fakturiert noch storniert sind.
            AND ( (NOT MergeLagAbg_CheckLgOrtUE) OR (COALESCE(l_lgort_ue,'') = COALESCE(rec.l_lgort_ue,'')))-- ... und ggf. auf gleichem Lagerort kommissioniert sind
            AND ( (NOT MergeLagAbg_CheckChnr   ) OR (COALESCE(l_lgchnr,''  ) = COALESCE(rec.l_lgchnr,'')))  -- ... und ggf. die gleiche Chargen-Nummer haben
        ;
        -- Wenn das alles erfüllt ist, fassen wir die Positionen zusammen
       END IF;


      uebernahme := rec.l_abgg; --Immer die Menge aus Lagerabgang übernehmen
      IF ROUND(menge,4) <> ROUND(rec.l_abgg,4) THEN
        RAISE EXCEPTION 'TWawi.beleg_p__lieferscheinv__from__lagerabgang__create: % % ', lang_text(13198), rec.l_nr;
       END IF;


      -- Erstellen Position
      IF (addLiefPosID IS NULL) THEN --Nicht zusammenfassen
        -- SELECT nextval('belegpos_belp_id_seq') INTO posid;

        --Belegposition anlegen
        INSERT INTO lieferschein_pos (
          belp_dokument_id, belp_ag_id,
          belp_aknr, belp_akbez, belp_mce, belp_projektnummer,
          belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
          belp_menge,belp_dokutxt, belp_dokutxt_rtf, belp_storniert,
          belp_erstelldatum, belp_termin, belp_txt, belp_txt_rtf,
          belp_bstat, belp_bstat1, belp_bstat2
        ) VALUES (
          docRec.beld_id,rec.l_ag_id,
          rec.l_aknr, rec.akbez, rec.l_abg_mec, rec.l_an_nr,
          rec.l_krz, rec.l_krzl, rec.l_krzf, rec.l_bda,
          uebernahme, rec.l_azutx, rec.l_azutx_rtf, NOT Verrechenbar,
          rec.l_ldat, rec.l_akdat, rec.ag_postxt, rec.ag_postxt_rtf,
          rec.ag_bstat, rec.ag_bstat1, rec.ag_bstat2 -- #7895
        ) RETURNING belp_id INTO posid;

        UPDATE lifsch SET l_belp_id = posid, l_inliefdok = true WHERE l_nr = rec.l_nr; --Belegposition in lifsch zurückschreiben

        -- PERFORM TBeleg.LFS_Update_Auftg(rec.l_ag_id);  >>  von lagerabgang (lifsch) aus

      ELSE  --Lagerabgänge zusammenfassen zu einer Lieferscheinposition
        UPDATE lieferschein_pos SET belp_menge = belp_menge + rec.l_abgg    -- Menge aufaddieren
          WHERE belp_id = addLiefPosID;

        UPDATE lifsch SET l_belp_id = addLiefPosID, l_inliefdok = true WHERE l_nr = rec.l_nr; --Belegposition in lifsch zurückschreiben
      END IF;

      -- Wenn die Position aus Lagerabgang eines Beistellmaterials stamm und das die erste Position ist, markieren wir den Lieferschein entsprechend.
      IF Beistellung THEN

        UPDATE lieferschein SET beld_belegart = 6
          WHERE (beld_id = docRec.beld_id)
            AND (beld_belegart <> 6)
            AND (SELECT COUNT(*) FROM lieferschein_pos WHERE belp_dokument_id = docRec.beld_id) = 1;

       END IF;

      RETURN  posid;
     END $$ LANGUAGE plpgsql VOLATILE;




 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__lieferscheinv__from__verkauf_p__create(IN auftgdbrid VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$ /*TWawi*/
     DECLARE rec     RECORD;
         docRec     RECORD;
           frei     BOOLEAN;
          belegid   INTEGER;
            docid   INTEGER;
           versart  VARCHAR;
     BEGIN

      SELECT beld_id INTO docid FROM lieferschein WHERE beld_dokunr = belegdoknr;

      -- Belegdokument noch anlegen? Falls es das schon gibt, haengen wir Positionen an.
      IF NOT (docid IS NULL) THEN
        RETURN docid;
      END IF;

      --Gibt es Auftrag zum Lieferschein oder war das vielleicht freier Lagerabgang?
      --SELECT (l_ag_id IS NULL) INTO frei FROM lifsch WHERE lifsch.dbrid = lifschdbrid;

      -- Wir sammeln mal alle möglichen Daten im System
      SELECT COALESCE(atd_vers,a1_vers) AS versart,
             COALESCE(atd_v_id, (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))) as versartID,
             ag_stk, ag_id, ag_lkn, ag_krzl, ag_krzf, atd_ld_auftg, ag_kdatum, ag_ldatum, ag_datum,
             ag_an_nr, atd_apkrzl, atd_ap, atd_apint, atd_versandort
          INTO rec
             FROM auftg     LEFT JOIN adk1 ON a1_krz = ag_lkn    -- <= Bestelleradresse gibt Versandart vor.
                            LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
             WHERE auftg.dbrid = auftgdbrid;

      -- Belegdokument anlegen
      INSERT INTO lieferschein (
          beld_dokunr, beld_apkrzl, beld_ap, beld_versandart, beld_versandartbem,
          beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_erstelldatum, beld_refbeleg
          , beld_versandort
      ) VALUES (
          belegdoknr, rec.atd_apkrzl, rec.atd_ap, rec.versartID, rec.versart,
          rec.ag_lkn, rec.ag_krzl, rec.ag_krzf, current_date, rec.atd_ld_auftg --527="Lieferschein"
          , rec.atd_versandort
      ) RETURNING beld_id INTO docid;

      RETURN docid;
     END $$ LANGUAGE plpgsql VOLATILE;
 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__lieferscheinv__from__verkauf_p__create(IN Auftgdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$
     DECLARE rec         RECORD;
             docRec      RECORD;
             frei        BOOLEAN;
             posid       INTEGER;
             uebernommen NUMERIC;
             uebernahme  NUMERIC;
             menge_gme   NUMERIC;
     BEGIN
      -- Wir sammeln mal alle möglichen Daten im System
      SELECT ag_akbz AS akbez,
             --Versandart holen, versuchen V_ID zu finden.
             COALESCE(atd_vers, a1_vers) AS versart,
             COALESCE(atd_v_id, (SELECT v_id FROM versart WHERE v_art = TRIM(a1_vers))) as versartID,
             COALESCE(ag_stk, 0) as stk, ag_id,  ag_nr, ag_pos,
             ag_mcv, ag_lkn, ag_krzl, ag_krzf, ag_stk_uf1,
             ag_aknr, ag_an_nr, ag_kdatum, ag_ldatum, ag_datum,
             ag_bda,ag_bdapos, IFTHEN(TSystem.Settings__GetBool('lifsch_dont_use_auftgtxt'),
                    (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txt,
                    COALESCE(ag_txt, (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txt)) as dokutxt,
                    IFTHEN(TSystem.Settings__GetBool('lifsch_dont_use_auftgtxt'),
                    (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txtrtf,
                    COALESCE(ag_txt_rtf, (tartikel.adtx_getArtTxtLang(ak_nr, 'LS', ag_krzl)).txtrtf)) AS dokutxt_rtf, ag_postxt, ag_postxt_rtf, (TSystem.Settings__Get('BASIS_W')) AS waer, m_uf,
             ag_bstat, ag_bstat1, ag_bstat2 -- #7895
             INTO rec
             FROM auftg     JOIN artmgc ON ag_mcv = m_id
                            JOIN art ON ak_nr = ag_aknr
                            LEFT JOIN adk1 ON a1_krz = ag_lkn
                            LEFT JOIN auftgdokutxt ON ag_dokunr = atd_dokunr
             WHERE auftg.dbrid = auftgdbrid;

      SELECT * INTO docRec FROM lieferschein WHERE beld_dokunr = belegdoknr;

      -- Übernommen in GME
      SELECT SUM(belp_menge_gme) INTO uebernommen FROM lieferschein_pos WHERE belp_ag_id = rec.ag_id;

      --Zu übernehmende Menge in GME
      menge_gme:=menge / Ifthen(rec.m_uf=0,1,rec.m_uf);

      --Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
      IF (menge IS NULL) THEN
        --Uebernahme ist in ME des Wareneingangs
        uebernahme:=( rec.ag_stk * (1-COALESCE(uebernommen,0) / IfThen(rec.ag_stk_uf1 = 0, 1, rec.ag_stk_uf1)));
      ELSE
        --Wenn mehr übernommen werden soll als zugegangen abzgl. schon uebernommen, auf Restbestand zurücksetzen
        IF ((menge_gme + uebernommen) > rec.ag_stk_uf1) THEN
          uebernahme:=(rec.ag_stk_uf1 - uebernommen)*Ifthen(rec.m_uf=0,1,rec.m_uf);
        ELSE
          uebernahme:=menge;
        END IF;
      END IF;

      IF (uebernahme < 0) THEN
        uebernahme:=0;
      END IF;

      --Belegposition mitnehmen
      INSERT INTO lieferschein_pos (
         belp_dokument_id,belp_ag_id,
         belp_aknr, belp_akbez, belp_mce, belp_projektnummer,
         belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
         belp_menge, belp_dokutxt, belp_dokutxt_rtf, belp_txt, belp_txt_rtf,
         belp_bstat, belp_bstat1, belp_bstat2
       ) VALUES (
         docRec.beld_id,rec.ag_id,
         rec.ag_aknr, rec.akbez, rec.ag_mcv, rec.ag_an_nr,
         rec.ag_lkn, rec.ag_krzl, rec.ag_krzf, COALESCE(rec.ag_bda, '') || COALESCE(' / ' || rec.ag_bdapos, ''),
         uebernahme, rec.dokutxt, rec.dokutxt_rtf, rec.ag_postxt, rec.ag_postxt_rtf,
         rec.ag_bstat, rec.ag_bstat1, rec.ag_bstat2 -- #7895
       ) RETURNING belp_id INTO posid;

      --//auch PrintSetting 'psPriceMainPos' übernehmen
      PERFORM TReporting.recnokeyword__print_setting__copy('auftg', rec.ag_id, 'belegpos', posid); --TODO klärung

      RETURN  posid;
     END $$ LANGUAGE plpgsql VOLATILE;


 --
--
-- RechnungV >> Ausgangsrechnung
 -- Rechnungszeile aus Lieferschein
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__from__lieferscheinv_p__create(bebnr VARCHAR, lifschdokunr VARCHAR, belpid INTEGER, lifschmenge NUMERIC DEFAULT NULL) RETURNS VOID AS $$
     DECLARE lifschauftg RECORD;
             belkopfr RECORD;
             tmpr RECORD;
             rab  NUMERIC;
             rabw NUMERIC;
             rabhint VARCHAR;
             belpos SMALLINT;
             belabzudbrids VARCHAR[];
             grab NUMERIC;
             faktmenge NUMERIC;
             vkpvkp  NUMERIC;
             bzzubez VARCHAR;
             bzzubez_rtf VARCHAR;
             akbz VARCHAR;
             steucodewarned BOOLEAN;
             bzid INTEGER;
             bem1_txt TEXT;
             bem2_txt TEXT;
             bem1_txt_rtf TEXT;
             bem2_txt_rtf TEXT;
     BEGIN
      --- #8083; die Mengenangabe ist nur zulässig, wenn auch eine belp_id mitgegeben wird, sonst Exception.
      IF lifschmenge IS NOT NULL AND COALESCE(belpid, 0) = 0 THEN
         RAISE EXCEPTION '%', langtext(29117);  -- Teilmenge kann nicht übernommen werden, weil kein Bezug zum Lieferschein vorhanden ist.
       END IF;
      ---
      SELECT be_umr, be_rkrz, be_waco, be_steucode1, be_steuproz1, be_steucode2, be_steuproz2 INTO belkopfr FROM belkopf WHERE be_bnr=bebnr;
      steucodewarned:=False;
      --wir holen uns die Daten aus Lieferschein und Auftrag
      FOR lifschauftg IN SELECT lieferschein.*, lieferschein_pos.*, auftg.*, ak_vkpbas, COALESCE(ag_konto, ak_zeko) AS ak_zeko, auftgdokutxt.atd_zak, auftgdokutxt.atd_skv, auftgdokutxt.atd_sks, auftgdokutxt.atd_vers, auftgdokutxt.atd_gesrab,
                                auftgdokutxt.atd_txt, auftgdokutxt.atd_txt_rtf, auftgdokutxt.atd_txt1, auftgdokutxt.atd_txt1_rtf, belkopfr.be_rkrz AS krz,
                                    -- #7715
                                (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txt    AS ak_faktxt,
                                (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txtrtf AS ak_faktxt_rtf,

                                ag_txt, belp_dokutxt, ag_txt_rtf, belp_dokutxt_rtf
                           FROM lieferschein_pos JOIN lieferschein ON belp_dokument_id = beld_id
                           LEFT OUTER JOIN auftg ON belp_ag_id=ag_id
                           LEFT OUTER JOIN art   ON belp_aknr=ak_nr
                           LEFT OUTER JOIN auftgdokutxt ON atd_dokunr=ag_dokunr

                          WHERE beld_dokunr=lifschdokunr
                            AND (NOT belp_erledigt)
                            AND (NOT belp_storniert)  --(Erledigt = Schon verrechnet, Storniert = Nicht verrechenbar)
                            AND belp_id = COALESCE(belpid,belp_id) -- Nur die eine Belegposition wenn angegeben
                          ORDER BY ag_nr, ag_pos, belp_pos        
      LOOP

       belpos := tfaktura.belzeilmaxpos(bebnr);
       --
       IF belpos=1 THEN--erste Position, Bezahldaten aus Auftragskopf?
            --in Belegkopf die Daten (Anschreiben und Schlußtext) aus Auftrag/Lieferschein eintragen
            UPDATE belkopf SET
                    be_sks=COALESCE(lifschauftg.atd_sks, be_sks),
                    be_skv=COALESCE(lifschauftg.atd_skv, be_skv),
                    be_zak=COALESCE(lifschauftg.atd_zak, be_zak),
                    be_vers=COALESCE(CAST(lifschauftg.beld_versandartbem AS VARCHAR(50)), be_vers),
                    be_liefkrz=COALESCE(be_liefkrz, lifschauftg.belp_krzlieferung),
                    be_waco=lifschauftg.ag_waer,
                    be_wabk=wa_abkz,
                    be_umr=wa_kurs,
                    be_steucode2=IFTHEN(lifschauftg.ag_steucode IS DISTINCT FROM be_steucode1, lifschauftg.ag_steucode, be_steucode2), --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
                    be_steuproz2=IFTHEN(lifschauftg.ag_ustpr IS DISTINCT FROM be_steuproz1, lifschauftg.ag_ustpr, be_steuproz2) --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
            FROM bewa
            WHERE wa_einh=lifschauftg.ag_waer
                    AND
                    be_bnr=bebnr
            RETURNING be_steucode2, be_steuproz2 INTO belkopfr.be_steucode2, belkopfr.be_steuproz2
            ;

            /*   #10669
            'belkopf_dont_use_lifschtxt' = :
               TRUE  -> Auftragstext prüfen, wenn vorhanden übernehmen, sonst Faktura - Vorgabetext Bemerkungsverwaltung lassen
               FALSE -> Lieferscheintext prüfen,wenn vorhanden übernehmen, sonst Faktura - Vorgabetext Bemerkungsverwaltung lassen
               LG: Dringender Fix, Spektra will immer den Bemerkungsverwaltungstext und nie die aus Auftrag oder Lieferschein. Wird
                   mit Folgeticket nach Überarbeitung entfernt.
                 #12291
               belkopf__b_i > es sind hier bereits die Texte der Bemerkungsverwaltung vorhanden!                   
            */
            IF NOT TSystem.Settings__GetBool('belkopf__belarzu__always__bemerkungsverwaltung')
            THEN   
              IF TSystem.Settings__GetBool('belkopf_dont_use_lifschtxt') THEN -- Auftragstext übernehmen wenn Texte nicht leer sind
                 IF (lifschauftg.atd_txt IS NOT NULL) AND (lifschauftg.atd_txt <> '') THEN
                    bem1_txt = lifschauftg.atd_txt;
                    bem1_txt_rtf = lifschauftg.atd_txt_rtf;
                 ELSE
                    SELECT txt, txtrtf INTO bem1_txt, bem1_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_KOPF', prodat_languages.adk1_spco(lifschauftg.krz));
                 END IF;
                 IF (lifschauftg.atd_txt1 IS NOT NULL) AND (lifschauftg.atd_txt1 <> '') THEN
                    bem2_txt = lifschauftg.atd_txt1;
                    bem2_txt_rtf = lifschauftg.atd_txt1_rtf;
                 ELSE
                    SELECT txt, txtrtf INTO bem2_txt, bem2_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_FUSS', prodat_languages.adk1_spco(lifschauftg.krz));
                 END IF;
              ELSE                    -- Lieferscheintext übernehmen wenn Texte nicht leer sind
                 IF (lifschauftg.beld_kopftext IS NOT NULL) AND (lifschauftg.beld_kopftext <> '') THEN
                    bem1_txt = lifschauftg.beld_kopftext;
                    bem1_txt_rtf = lifschauftg.beld_kopftext_rtf;
                 ELSE
                    SELECT txt, txtrtf INTO bem1_txt, bem1_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_KOPF', prodat_languages.adk1_spco(lifschauftg.krz));
                 END IF;
                 IF (lifschauftg.beld_fusstext IS NOT NULL) AND (lifschauftg.beld_fusstext <> '') THEN
                    bem2_txt = lifschauftg.beld_fusstext;
                    bem2_txt_rtf = lifschauftg.beld_fusstext_rtf;
                 ELSE
                    SELECT txt, txtrtf INTO bem2_txt, bem2_txt_rtf FROM belarzu__zu_tit__gettxtrtf('DOKFAKT_TXT_FUSS', prodat_languages.adk1_spco(lifschauftg.krz));
                 END IF;
              END IF;
              UPDATE belkopf SET be_bem1 = bem1_txt,
                   be_bem2 = bem2_txt,
                   be_bem1_rtf = bem1_txt_rtf,
                   be_bem2_rtf = bem2_txt_rtf WHERE be_bnr=bebnr;
            END IF;
        END IF;
       --Pos.Rabatte nur übernehmen wenn Artikel Rabattfähig
       IF lifschauftg.ag_canRabatt THEN
         rab:=lifschauftg.ag_arab;
         If lifschauftg.ag_rabhint=lang_text(21333) OR lifschauftg.ag_rabhint IS NULL then --währungsrabatt aktualisieren
            rabw:=adwarab_rab FROM adkbewarab JOIN bewa ON wa_einh=lifschauftg.ag_waer WHERE (adwarab_ad_krz=lifschauftg.ag_krzf OR adwarab_ad_vpber=lifschauftg.ag_kukl) AND adwarab_waco=lifschauftg.ag_waer AND wa_kurs BETWEEN adwarab_kurs_ab AND adwarab_kurs_bis AND COALESCE(adwarab_auslauf, current_date)>=current_date ORDER BY adwarab_auslauf, adwarab_ad_krz=lifschauftg.ag_krzf NULLS LAST;
            IF rabw IS NOT NULL THEN
                rab:=rabw;
                rabhint:=lang_text(21333);
            END IF;
         END IF;
         grab:=lifschauftg.atd_gesrab;
        ELSE
         rab:=0; -- Wird normalerweise bei Posten Auftg = 0 gesetzt, hier nur Sicherheitshalber nochmal
         grab:=0;
        END IF;
       -- In Rechnung soll immer Text aus Artikelstamm genommen werden #8296
       IF TSystem.Settings__GetBool('bzUseArtTxt') THEN
         bzzubez    := lifschauftg.ak_faktxt;
         bzzubez_rtf:= lifschauftg.ak_faktxt_rtf;
        ELSE
         -- Je nach Setting entweder zuerst immer Auftragspositionstext oder Fakturatext aus Artikelstamm nehmen.
         IF (TSystem.Settings__GetBool('bzUseAuftTxt')) THEN
           bzzubez    :=COALESCE(lifschauftg.ag_txt,     lifschauftg.ak_faktxt,     lifschauftg.belp_dokutxt);
           bzzubez_rtf:=COALESCE(lifschauftg.ag_txt_rtf, lifschauftg.ak_faktxt_rtf, lifschauftg.belp_dokutxt_rtf);
         ELSE
           bzzubez    :=COALESCE(lifschauftg.ak_faktxt,     lifschauftg.belp_dokutxt,     lifschauftg.ag_txt);
           bzzubez_rtf:=COALESCE(lifschauftg.ak_faktxt_rtf, lifschauftg.belp_dokutxt_rtf, lifschauftg.ag_txt_rtf);
         END IF;
        END IF;
       -- Artikelbezeichnung vorzugsweise aus Auftrag
       IF (TSystem.Settings__GetBool('bzUseAuftTxt')) THEN
         akbz := COALESCE(lifschauftg.ag_akbz, lifschauftg.belp_akbez);
        ELSE
         akbz := lifschauftg.belp_akbez;
        END IF;
       -- Warnung, wenn Steuercode aus Auftragsposition nicht Steuercode aus Rechnungskopf enspricht
       IF lifschauftg.ag_steucode NOT IN (belkopfr.be_steucode1,  belkopfr.be_steucode2) AND (NOT steucodewarned) THEN
         PERFORM PRODAT_HINT(langtext(12761));
         steucodewarned:=TRUE;
        END IF;
       faktmenge:=tartikel.me__menge_uf1__in__menge(lifschauftg.belp_mce, lifschauftg.belp_menge_gme-lifschauftg.belp_menge_done_gme);
       --- #8033
       IF (lifschmenge IS NOT NULL) THEN
          IF (lifschmenge <= faktmenge) THEN
             faktmenge := lifschmenge;
          ELSE
             RAISE EXCEPTION '% %', langtext(29116), faktmenge::NUMERIC(12,4);    -- 'Teilmenge ist größer als offene Menge. Zulässige Menge ist maximal:'
          END IF;
       END IF;
       -- freier Lieferschein, Preis laden!
       IF lifschauftg.ag_id IS NULL THEN
            SELECT * INTO tmpr FROM artikel_vkppreis(lifschauftg.belp_aknr, belkopfr.be_rkrz, NULL, faktmenge, belkopfr.be_waco, belkopfr.be_umr, lifschauftg.belp_menge / Do1If0(lifschauftg.belp_menge_gme));
            vkpvkp:=tmpr.vkp;
            rab:=tmpr.rab;
       END IF;
       --
       INSERT INTO belzeil_auftg_lif
           (bz_be_bnr, bz_pos, bz_aknr, bz_akbz,
            bz_mce, bz_vkp_mce,
            bz_fakt, bz_steucode, bz_steuproz,
            bz_auftg, bz_auftgpos,
            bz_preis, bz_preiseinheit, /*bz_vkp,*/  bz_vkpbas,
            bz_arab, bz_rabhint, bz_gesrab, bz_canrabatt,
            bz_zubez, bz_zubez_rtf, bz_an_nr,
            bz_ks, bz_zeko,
            bz_belp_id, bz_bda,
            bz_hwpos, bz_auftghpos, bz_vkptotalpos)
        VALUES
           (bebnr, belpos, lifschauftg.belp_aknr, akbz,
            lifschauftg.belp_mce, COALESCE(lifschauftg.ag_vkp_mce, IFTHEN(lifschauftg.ag_mcv = lifschauftg.belp_mce, NULL, lifschauftg.ag_mcv)),
            faktmenge, COALESCE(lifschauftg.ag_steucode, belkopfr.be_steucode1), COALESCE(lifschauftg.ag_ustpr, belkopfr.be_steuproz1, 0),
            lifschauftg.ag_nr, lifschauftg.ag_pos,
            COALESCE(lifschauftg.ag_preis, vkpvkp), lifschauftg.ag_preiseinheit, /*vkpvkp,*/ COALESCE(lifschauftg.ag_vkpbas, lifschauftg.ak_vkpbas),
            COALESCE(rab,0), COALESCE(lifschauftg.ag_rabhint, rabhint), COALESCE(grab,0), COALESCE(lifschauftg.ag_canrabatt, TRUE),
            bzzubez, bzzubez_rtf, lifschauftg.belp_projektnummer,
            lifschauftg.ag_ks, lifschauftg.ak_zeko,
            lifschauftg.belp_id, lifschauftg.belp_referenz,
            lifschauftg.ag_hwpos, lifschauftg.ag_hpos, COALESCE(lifschauftg.ag_vkptotalpos,FALSE) )
        RETURNING bz_id INTO bzid;

       -- auch PrintSetting 'psPriceMainPos' übernehmen
       PERFORM TReporting.recnokeyword__print_setting__copy('belegpos', lifschauftg.belp_id, 'belzeil_auftg_lif', bzid); --TODO

       -- Abzuschläge aus Auftrag holen
       SELECT TWawi.Abzu_Copy('Auftg_Abzu', lifschauftg.ag_id::VARCHAR, 'BelKopf_Abzu', bebnr, faktmenge) INTO belabzudbrids;
       -- Daten nachtragen, die nicht von Abzu_Copy übernommen wurden, da nicht im View-Standard enthalten. Verknüpfung mit Auftrag.
       UPDATE belabzu SET beaz_agnr = lifschauftg.ag_nr, beaz_agpos = lifschauftg.ag_pos, beaz_belpos = belpos
         WHERE belabzu.dbrid = ANY(belabzudbrids);
       -- Apint aus Zutänder MA Auftrag nehmen, wenn automatische Auslieferung
       IF EXISTS(SELECT TRUE FROM lifsch WHERE l_nr=lifschdokunr AND l_lgort='ALAUTO') THEN
            UPDATE belkopf SET
              be_apint=COALESCE(lifschauftg.ag_kontakt,current_user)
            WHERE be_bnr=bebnr;
       END IF;
       --
      END LOOP;
      RETURN;
     END $$ LANGUAGE plpgsql;


 -- Rechnungszeile aus Auftrag
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnungv__from__verkauf_p__create(bebnr VARCHAR, auftgdokunr INTEGER, agid INTEGER ) RETURNS VOID AS $$
     DECLARE recno Integer;
             auftgrec RECORD;
             belkopfr RECORD;
             belpos SMALLINT;
             belabzudbrids VARCHAR[];
             rab  NUMERIC;
             rabw NUMERIC;
             rabhint VARCHAR;
             grab  NUMERIC;
             bzzubez VARCHAR;
             bzzubez_rtf VARCHAR;
             steucodewarned BOOLEAN;
             bzid INTEGER;
     BEGIN
      --Steuersatz im Belegkopf
      SELECT be_umr, be_rkrz, be_waco, be_steucode1, be_steuproz1, be_steucode2, be_steuproz2 INTO belkopfr FROM belkopf WHERE be_bnr=bebnr;

      recno:=0; --MF letzte Belegzeilenpos rauskramen
      steucodewarned:=FALSE;
      FOR auftgrec IN SELECT auftg.*, COALESCE(ag_konto, ak_zeko) AS ak_zeko, auftgdokutxt.atd_zak, auftgdokutxt.atd_skv, auftgdokutxt.atd_sks, auftgdokutxt.atd_vers, auftgdokutxt.atd_gesrab,
        -- #7715
        (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txt    AS ak_faktxt,
        (tartikel.adtx_getArtTxtLang(ak_nr, 'RE', belkopfr.be_rkrz)).txtrtf AS ak_faktxt_rtf

                     FROM auftg JOIN auftgdokutxt ON atd_dokunr=ag_dokunr
                                JOIN art ON ag_aknr = ak_nr
                     WHERE ag_dokunr=auftgdokunr AND NOT ag_storno AND ag_id = COALESCE(agid,ag_id) --Wenn agid angegeben, dann nur die einer Position bitte.
                     ORDER BY ag_nr, ag_pos
      LOOP
            --
            IF recno=0 THEN--erste Position, Bezahldaten aus Auftragskopf?
                    UPDATE belkopf SET
                            be_sks=COALESCE(auftgrec.atd_sks, be_sks),
                            be_skv=COALESCE(auftgrec.atd_skv, be_skv),
                            be_zak=COALESCE(auftgrec.atd_zak, be_zak),
                            be_vers=COALESCE(auftgrec.atd_vers, be_vers),
                            be_liefkrz=COALESCE(be_liefkrz, auftgrec.ag_krzl),
                            be_waco=auftgrec.ag_waer,
                            be_wabk=wa_abkz,
                            be_umr=wa_kurs,
                            be_steucode2=IFTHEN(auftgrec.ag_steucode IS DISTINCT FROM be_steucode1, auftgrec.ag_steucode, be_steucode2), --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
                            be_steuproz2=IFTHEN(auftgrec.ag_ustpr IS DISTINCT FROM be_steuproz1, auftgrec.ag_ustpr, be_steuproz2) --Bei Rechnungsanlage steht im Steuercode 1 immer der Stammdatensteuercode
                    FROM bewa
                    WHERE wa_einh=auftgrec.ag_waer
                            AND
                            be_bnr=bebnr
                    RETURNING be_steucode2, be_steuproz2 INTO belkopfr.be_steucode2, belkopfr.be_steuproz2
                    ;
            END IF;
            recno:=1;
            --Pos.Rabatte nur übernehmen wenn Artikel Rabattfähig
            IF auftgrec.ag_canRabatt THEN
                    rab:=auftgrec.ag_arab;
                    If auftgrec.ag_rabhint=lang_text(21333) OR auftgrec.ag_rabhint IS NULL then --währungsrabatt aktualisieren, Außer es ist irgendein Sonderrabtt drin mit Text
                            rabw:=adwarab_rab FROM adkbewarab JOIN bewa ON wa_einh=auftgrec.ag_waer WHERE adwarab_ad_krz=auftgrec.ag_krzf AND adwarab_waco=auftgrec.ag_waer AND wa_kurs BETWEEN adwarab_kurs_ab AND adwarab_kurs_bis AND COALESCE(adwarab_auslauf, current_date)>=current_date ORDER BY adwarab_auslauf, adwarab_ad_krz=auftgrec.ag_krzf NULLS LAST;
                            IF rabw IS NOT NULL THEN
                                rab:=rabw;
                                rabhint:=lang_text(21333);
                            END IF;
                    END IF;
                    grab:=auftgrec.atd_gesrab;
            ELSE
                    rab:=0; -- Wird normalerweise bei Posten Auftg = 0 gesetzt, hier nur Sicherheitshalber nochmal
                    grab:=0;
            END IF;
            -- In Rechnung soll immer Text aus Artikelstamm genommen werden #8296
            IF TSystem.Settings__GetBool('bzUseArtTxt') THEN
              bzzubez    := auftgrec.ak_faktxt;
              bzzubez_rtf:= auftgrec.ak_faktxt_rtf;
            ELSE
              -- Je nach Setting entweder zuerst immer Auftragspositionstext oder Fakturatext aus Artikelstamm nehmen.
              IF (TSystem.Settings__GetBool('bzUseAuftTxt')) THEN
                bzzubez    :=COALESCE(auftgrec.ag_txt,auftgrec.ak_faktxt );
                bzzubez_rtf:=COALESCE(auftgrec.ag_txt_rtf, auftgrec.ak_faktxt_rtf);
              ELSE
                bzzubez    :=COALESCE(auftgrec.ak_faktxt,auftgrec.ag_txt);
                bzzubez_rtf:=COALESCE(auftgrec.ak_faktxt_rtf,auftgrec.ag_txt_rtf);
              END IF;
            END IF;

            -- Warnung, wenn Steuercode aus Auftragsposition nicht Steuercode aus Rechnungskopf enspricht
            IF auftgrec.ag_steucode NOT IN (belkopfr.be_steucode1,  belkopfr.be_steucode2) AND (NOT steucodewarned) THEN
                PERFORM PRODAT_HINT(langtext(12761));
                steucodewarned:=TRUE;
            END IF;

            belpos := tfaktura.belzeilmaxpos(bebnr);
            INSERT INTO belzeil_auftg_lif (bz_be_bnr, bz_pos, bz_hwpos, bz_aknr, bz_akbz, bz_ks, bz_zeko,
                            bz_mce, bz_mcbez, bz_vkp_mce, bz_zubez, bz_zubez_rtf, bz_fakt,
                            bz_steucode, bz_steuproz,
                            bz_auftg, bz_auftgpos, bz_auftghpos, bz_preis, bz_preiseinheit, bz_vkp, bz_vkpbas, bz_vkptotalpos, bz_arab, bz_rabhint,
                            bz_gesrab, bz_canrabatt, bz_an_nr, bz_bda)
            SELECT bebnr, belpos, auftgrec.ag_hwpos, auftgrec.ag_aknr, auftgrec.ag_akbz, auftgrec.ag_ks, auftgrec.ak_zeko,
                            auftgrec.ag_mcv, lang_artmgc_id(auftgrec.ag_mcv, prodat_languages.customerlang(auftgrec.ag_krzf)),
                            auftgrec.ag_vkp_mce, bzzubez, bzzubez_rtf,  tartikel.me__menge_uf1__in__menge(auftgrec.ag_mcv, auftgrec.ag_stk_uf1-auftgrec.ag_stkf),
                            COALESCE(auftgrec.ag_steucode, belkopfr.be_steucode1), COALESCE(auftgrec.ag_ustpr, belkopfr.be_steuproz1, 0),
                            auftgrec.ag_nr, auftgrec.ag_pos, auftgrec.ag_hpos, auftgrec.ag_preis, auftgrec.ag_preiseinheit,
                            auftgrec.ag_vkp, auftgrec.ag_vkpbas, auftgrec.ag_vkptotalpos, COALESCE(rab,0), COALESCE(auftgrec.ag_rabhint, rabhint), COALESCE(grab,0), auftgrec.ag_canrabatt,
                            auftgrec.ag_an_nr, COALESCE( auftgrec.ag_bda,'') ||  COALESCE( ' / ' || auftgrec.ag_bdapos,'')
            RETURNING bz_id INTO bzid;

            -- auch PrintSetting 'psPriceMainPos' übernehmen
            PERFORM TReporting.recnokeyword__print_setting__copy('auftg', auftgrec.ag_id, 'belzeil_auftg_lif', bzid);

            UPDATE auftg SET ag_done = TRUE WHERE ag_id = auftgrec.ag_id AND Round(ag_stk_uf1,4)=Round(ag_stkf,4);

            --abzuschläge aus Auftrag holen
            SELECT TWawi.Abzu_Copy('Auftg_Abzu', auftgrec.ag_id::VARCHAR, 'BelKopf_Abzu', bebnr, tartikel.me__menge_uf1__in__menge(auftgrec.ag_mcv, auftgrec.ag_stk_uf1-auftgrec.ag_stkf)) INTO belabzudbrids;
            -- Daten nachtragen, die nicht von Abzu_Copy übernommen wurden, da nicht im View-Standard enthalten. Verknüpfung mit Auftrag.
            UPDATE belabzu SET beaz_agnr = auftgrec.ag_nr, beaz_agpos = auftgrec.ag_pos, beaz_belpos = belpos
              WHERE belabzu.dbrid = ANY(belabzudbrids);

      END LOOP;
      RETURN;
     END $$ LANGUAGE plpgsql;
 --
-- RechnungE >> Eingangerechnungen
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__rechnunge__from__adk2__einkauf__create(IN ldsdokdbrid INTEGER, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  DECLARE rec     RECORD;
          docRec  RECORD;
          belegid INTEGER;
          docid   INTEGER;
          pruefer VARCHAR;
  BEGIN

   SELECT beld_id INTO docid FROM eingrechdokument WHERE beld_dokunr = belegdoknr;

   -- Belegdokument noch anlegen ?
   IF NOT (docid IS NULL) THEN
     RETURN docid;
   END IF;

   -- Wir sammeln mal alle möglichen Daten im System
   SELECT ltd_vers AS versart,
          ld_stk, ld_id, ld_aknr, ld_kn, ld_waer, ld_dokunr, ltd_gesrab,ld_eklos,
          ld_an_nr, ld_lkontakt, ld_lkontaktkrzl, ld_kontakt, ld_krzl, ld_krzf, ltd_zakbem,
          ltd_apkrzl, ltd_ap, ltd_apint, a2_zahlart,
          COALESCE(ltd_zak, a2_zak) AS zahlkond,
          COALESCE(ltd_sks, a2_sks) AS skontosatz,
          COALESCE(ltd_skv, a2_skv) AS skontotage,
          ldt_txt
       INTO rec
          FROM ldsdok    JOIN adk ON ad_krz = ld_kn
                         LEFT JOIN adk2 ON ad_krz = a2_krz
                         LEFT JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
                         LEFT JOIN ldsdoktxt     ON ldt_code = ld_code AND ldt_auftg = ld_auftg -- Zusatztext zur Bestellung kommt daher.
          WHERE ldsdok.dbrid = ldsdokdbrid;

   pruefer := NULL;
   -- Besteller soll Rechnungspruefer werden
   IF TSystem.Settings__GetBool('ERGPrueferIsEK') AND (COALESCE(rec.ld_kontakt,'') <> '')   THEN
     -- Wenn Zahlungslauf aktiv ist, darf das aber nur passieren, wenn die Zahlungsart feststeht.
     IF TSystem.Settings__GetBool('ER_Prodat_Zahlung') AND (rec.a2_zahlart IS NULL) THEN
       pruefer:=NULL;
     ELSE
       pruefer := rec.ld_kontakt;
     END IF;
   END IF;

   -- Belegdokument anlegen
   --   Falls Zahlungslauf bzw. DTA/SEPA aktiv ist, ist Zahlart Pflicht bevor Pruefer zugewiesen wird.
   INSERT INTO eingrechdokument (
       beld_dokunr, beld_apkrzl, beld_ap, beld_apint, beld_zak, beld_skv, beld_sks, beld_versandartbem,
       beld_zakbem, beld_gesamtrabatt, beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_waehr, beld_zahlart,
       beld_pruefer, beld_kopftext
   ) VALUES (
       belegdoknr, rec.ltd_apkrzl, rec.ltd_ap, rec.ltd_apint, rec.zahlkond, rec.skontotage, rec.skontosatz, rec.versart,
       rec.ltd_zakbem, COALESCE(rec.ltd_gesrab,0), COALESCE(rec.ld_krzl,'#'), rec.ld_kn, rec.ld_kn, rec.ld_waer, rec.a2_zahlart,
       pruefer, rec.ldt_txt
   ) RETURNING beld_id INTO docid;

   RETURN docid;
  END $$ LANGUAGE plpgsql VOLATILE;

 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__rechnunge__from__adk2__wendat__create(IN wendatdbrid INTEGER, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
     DECLARE rec     RECORD;
             docRec  RECORD;
             frei    BOOLEAN;
             --belegid INTEGER;
             docid   INTEGER;
             pruefer VARCHAR;
     BEGIN

      SELECT beld_id INTO docid FROM eingrechdokument WHERE beld_dokunr = belegdoknr;

      -- Belegdokument noch anlegen ?
      IF (docid IS NOT NULL) THEN
        RETURN docid;
       END IF;

      --Freier Wendat Satz?
      SELECT (w_lds_id IS NULL) INTO frei FROM wendat WHERE wendat.dbrid = wendatdbrid;

      -- Wir sammeln mal alle möglichen Daten im System
      SELECT IfThen(frei, a2_vers, ltd_vers) AS versart,
             w_zugang, ld_id, w_wen, w_aknr, w_l_krz, COALESCE(ld_waer, TSystem.Settings__Get('BASIS_W')) AS waer, w_lfsnr, ltd_gesrab,ld_eklos,
             ld_an_nr, ld_lkontakt, ld_lkontaktkrzl, ld_kontakt, ld_krzl, ld_krzf, ltd_zakbem,
             ltd_apkrzl, ltd_ap, ltd_apint, a2_zahlart,
             ldt_txt,
             COALESCE(ltd_zak, a2_zak) AS zahlkond,
             COALESCE(ltd_sks, a2_sks) AS skontosatz,
             COALESCE(ltd_skv, a2_skv) AS skontotage
          INTO rec
             FROM wendat    JOIN adk ON ad_krz = w_l_krz
                            LEFT JOIN adk2 ON ad_krz = a2_krz
                            LEFT JOIN ldsdok ON w_lds_id = ld_id
                            LEFT JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
                            LEFT JOIN ldsdoktxt     ON ldt_code = ld_code AND ldt_auftg = ld_auftg -- Zusatztext zur Bestellung kommt daher.
             WHERE wendat.dbrid = wendatdbrid;


      pruefer := NULL;
      -- Besteller soll Rechnungspruefer werden
      IF TSystem.Settings__GetBool('ERGPrueferIsEK') AND (COALESCE(rec.ld_kontakt,'') <> '')   THEN
        -- Wenn Zahlungslauf aktiv ist, darf das aber nur passieren, wenn die Zahlungsart feststeht.
        IF TSystem.Settings__GetBool('ER_Prodat_Zahlung') AND (rec.a2_zahlart IS NULL) THEN
          pruefer:=NULL;
        ELSE
          pruefer := rec.ld_kontakt;
        END IF;
       END IF;

      -- Belegdokument anlegen
      INSERT INTO eingrechdokument (
          beld_dokunr, beld_apkrzl, beld_ap, beld_apint, beld_zak, beld_skv, beld_sks, beld_versandartbem,
          beld_zakbem, beld_gesamtrabatt, beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_waehr,
          beld_zahlart, beld_pruefer, beld_kopftext
       ) VALUES (
          belegdoknr, rec.ltd_apkrzl, rec.ltd_ap, rec.ltd_apint, rec.zahlkond, rec.skontotage, rec.skontosatz, rec.versart,
          rec.ltd_zakbem, COALESCE(rec.ltd_gesrab,0), COALESCE(rec.ld_krzl,'#'), rec.w_l_krz, rec.w_l_krz, rec.waer,
          rec.a2_zahlart, pruefer, rec.ldt_txt
       ) RETURNING beld_id INTO docid;
      --
      RETURN docid;
     END $$ LANGUAGE plpgsql VOLATILE;
 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_k__rechnunge__from__adk2__create(IN adkrz VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  DECLARE rec     RECORD;
          docRec  RECORD;
          belegid INTEGER;
          docid   INTEGER;

  BEGIN
   SELECT beld_id INTO docid FROM eingrechdokument WHERE beld_dokunr = belegdoknr;
   -- Belegdokument noch anlegen ?
   IF (docid IS NOT NULL) THEN
     RETURN docid;
   END IF;

   SELECT a2_vers AS versart,
          a2_knr, a2_krz, a2_waco, a2_rabatt,
          ad_krz,
          a2_zahlart,
          a2_zak AS zahlkond,
          a2_sks AS skontosatz,
          a2_skv AS skontotage
       INTO rec
          FROM adk2
             JOIN adk ON ad_krz = a2_krz
          WHERE a2_krz = adkrz;

   -- Belegdokument anlegen
   INSERT INTO eingrechdokument (
       beld_dokunr, beld_apint, beld_zak, beld_skv, beld_sks, beld_versandartbem, beld_gesamtrabatt,
       beld_krzbesteller, beld_krzlieferung, beld_krzrechnung, beld_waehr, beld_zahlart, beld_erstelldatum
   ) VALUES (
       belegdoknr, current_user, rec.zahlkond, rec.skontotage, rec.skontosatz, rec.versart, COALESCE(rec.a2_rabatt,0),
       '#', rec.ad_krz, rec.ad_krz, rec.a2_waco, rec.a2_zahlart, current_date
   ) RETURNING beld_id INTO docid;

   RETURN docid;
  END $$ LANGUAGE plpgsql VOLATILE;

 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnunge__from__wendat__create(IN wendatdbrid varchar, IN belegdoknr varchar(30), IN menge numeric) RETURNS integer AS $$
     DECLARE rec     record;
             docRec     record;
             frei      BOOLEAN;
             --belegid integer;
             posid   integer;
             uebernommen numeric;
             uebernahme  numeric;
             menge_gme numeric;
             belpreis  numeric;
             egdatum   DATE;
     BEGIN
      --Freier Wendat Satz?
      SELECT (w_lds_id IS NULL) INTO frei FROM wendat WHERE wendat.dbrid = wendatdbrid;
      --- #8396
      SELECT MAX(e_gdatum) INTO egdatum
      FROM wendat
        JOIN epreis ON e_aknr = w_aknr AND e_lkn = w_l_krz
      WHERE wendat.dbrid = wendatdbrid;


      /* Aktuelles Verhalten (Preis-ME ggf. NULL) [09/2017, LG]
      * 1: Bestellt 20 m für 10 €/m  |  Lagerzugang =  20 m   |  ERG =  20 m  zu 10 €/m     | Menge durchgeben, Preis durchgeben
      * 2: Bestellt 20 m für 10 €/m  |  Lagerzugang = 200 kg  |  ERG = 200 kg zu  1 €/kg    | Menge umrechnen , Preis umrechnen, PME auf Lagerzugangs-ME setzen
      * 3: Bestellt 20 m für  1 €/kg |  Lagerzugang =  20 m   |  ERG =  20 m  zu  1 €/kg    | Menge durchgeben, PME durchgeben
      * 4: Bestellt 20 m für  1 €/kg |  Lagerzugang = 200 kg  |  ERG = 200 kg zu  1 €/kg    | Menge umrechnen , PME durchgeben
      */
      -- Wir sammeln mal alle möglichen Daten im System
      SELECT coalesce(IfThen(frei, e_preis, ld_preis),0)                  AS preis,        -- ld_ep_uf1 ist in GME umgerechnet und pro ME, also ohne Preiseinheiten.
             coalesce(IfThen(frei, e_preiseinheit, ld_preiseinheit),1)    AS preiseinheit, -- Preiseinheit, wenn nicht vorhanden ist das immer 1.
             e_mcv,
             w_zug_mec AS me,
             ld_mce,
             coalesce(IfThen(frei, e_rab, ld_arab),0) AS rabatt,
             IfThen(frei, e_best, ld_bem) AS refAknr,
             IfThen(frei, a2_vers, ltd_vers) AS versart,
             coalesce(w_zugang,0) AS w_zugang, coalesce(w_zugang_uf1,0) AS w_zugang_uf1, e_id, ld_id, w_wen, w_aknr, w_l_krz,
             coalesce(IfThen(frei, e_waer, ld_waer),TSystem.Settings__Get('BASIS_W')) AS waer, w_lfsnr, ltd_gesrab,ld_eklos,
             ld_an_nr, ld_lkontakt, ld_lkontaktkrzl, ld_kontakt, ld_krzl, ld_krzf, ltd_zakbem,
             ltd_apkrzl, ltd_ap, ltd_apint, a2_zahlart,
             m_uf, -- Umrechnungsfaktor von GME -> ME aus Wareneingang
             ld_a2_id,
             coalesce(ltd_zak, a2_zak) AS zahlkond,
             coalesce(ltd_sks, a2_sks) AS skontosatz,
             coalesce(ltd_skv, a2_skv) AS skontotage,
             coalesce(ld_ks, w_ks, ak_ks, ac_ks) AS ks,
             coalesce(ld_konto, ak_awko, ac_konto) AS konto,
             coalesce(ld_akbz, ak_bez) AS akbez,
             --Steuercode: Freier Wareneingang => Kredidaten, sonst Bestellung. Falls nicht vorhanden Artikelspezifsch oder Standard Einkaufssteuer aus Sys.Einstellung
             steu_z AS steucode,
             steu_proz AS steuproz,
             coalesce(IfThen(frei,wa_kurs,ld_kurs), 1) AS wakurs,
             -- Preismengeneinheit
             ld_ekp_mce AS ekp_mec, --NULL zulassen
             ak_canRabatt, ain_canSkonto,
             w_q_nr,
             ldt_txt, ld_txtint, ld_txtint_rtf --Einkaufstexte durchreichen
             INTO rec
             FROM wendat    JOIN art ON w_aknr = ak_nr
                            JOIN artcod ON ak_ac = ac_n
                            JOIN artmgc ON w_zug_mec = m_id
                            JOIN adk ON ad_krz = w_l_krz
                            LEFT JOIN adk2 ON ad_krz = a2_krz
                            LEFT JOIN ldsdok ON w_lds_id = ld_id
                            LEFT JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
                            LEFT JOIN ldsdoktxt     ON ldt_code = ld_code AND ldt_auftg = ld_auftg -- Zusatztext zur Bestellung kommt daher.
                            LEFT JOIN artinfo ON ain_ak_nr = ak_nr
                            --- #8396
                            LEFT JOIN epreis ON e_aknr = w_aknr AND e_lkn = w_l_krz AND e_gdatum = egdatum  --(SELECT MAX(e_gdatum) FROM epreis WHERE e_aknr = w_aknr AND e_lkn = w_l_krz)
                            LEFT JOIN bewa ON wa_einh = coalesce(IfThen(frei, e_waer, ld_waer),TSystem.Settings__Get('BASIS_W'))
                            CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get( coalesce(IfThen(frei, a2_wuco, ld_steucode)::integer, ain_steucode_ek,  TSystem.Settings__GetInteger('einksteucode')) )
             WHERE wendat.dbrid = wendatdbrid;

      belpreis := rec.Preis;
      -- Keine Preismengeneinheit in Bestellung.
      IF rec.ekp_mec IS NULL THEN

        -- Wenn Lagerzugangs-ME <> Bestell-ME müssen wir auf Lagerzugangs-ME umrechnen
        IF (rec.ld_mce IS DISTINCT FROM rec.me) THEN
          -- Umrechnen des Preis von Bestell-ME auf Grund-ME
          belpreis := tartikel.me__preis__in__preis_uf1( rec.ld_mce, belpreis);
          -- Umrechnen auf Lagerzugangs-ME aus dem Wareneingang
          belpreis := tartikel.me__preis_uf1__in__preis(rec.me,belpreis);
          -- Belegpos-Preis-ME auf Lagerzugangs-ME setzen
          rec.ekp_mec := rec.me;
        END IF;

        -- ELSE
        -- Bestellung hatte eine Preis-ME. Die reichen wir mit dem Preis durch und die Eingangsrechnung wird genauso dargestellt.
        -- Menge wird ggf. Lagerzugangs-ME umgerechnet.
      END IF;

      SELECT * INTO docRec FROM eingrechdokument WHERE beld_dokunr = belegdoknr;

      --SELECT bel_id INTO belegid FROM beleg WHERE bel_nummer = belegdoknr AND bel_belegtyp = belegtyp;

      -- Bereits in andere Positionen übernommen in GME (Teil-Lieferung / Verrechnung)
      SELECT SUM(belp_menge_gme) INTO uebernommen FROM eingrech_pos WHERE belp_w_wen = rec.w_wen;

      --Zu übernehmende Menge in GME
      menge_gme:=menge / Do1If0(rec.m_uf);

      --Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
      IF (menge IS NULL) THEN
        --Uebernahme ist in ME des Wareneingangs
        uebernahme:=( rec.w_zugang * (1-COALESCE(uebernommen,0) / IfThen(rec.w_zugang_uf1 = 0, 1, rec.w_zugang_uf1)));
       ELSE
        --Wenn mehr übernommen werden soll als zugegangen abzgl. schon uebernommen, auf Restbestand zurücksetzen
        IF ((menge_gme + uebernommen) > rec.w_zugang_uf1) THEN
          uebernahme:=(rec.w_zugang_uf1 - uebernommen)*Ifthen(rec.m_uf=0,1,rec.m_uf);
        ELSE
          uebernahme:=menge;
        END IF;
       END IF;

      IF (uebernahme < 0) THEN
        uebernahme:=0;
       END IF;

      --Belegposition mitnehmen
      INSERT INTO eingrech_pos (
        belp_dokument_id, belp_ld_id, belp_w_wen,
        belp_skontofaehig, belp_rabattfaehig, belp_konto, belp_kostenstelle, belp_kurs,
        belp_waehr, belp_steucode, belp_steuproz, belp_preis, belp_preiseinheit, belp_rabatt,
        belp_aknr, belp_akbez, belp_referenzaknr, belp_mce, belp_los, belp_projektnummer, belp_versandartbem, 
        belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
        belp_menge, belp_a2_id, belp_q_nr, belp_txt, belp_txt_rtf, belp_preis_mce
      ) VALUES (
        docRec.beld_id, rec.ld_id, rec.w_wen,
        COALESCE(rec.ain_canSkonto,TRUE), rec.ak_canRabatt, rec.konto, rec.ks, rec.wakurs,
        rec.waer, rec.steucode, rec.steuproz, belpreis, Do1If0(COALESCE(rec.preiseinheit,1)), rec.rabatt,
        rec.w_aknr, rec.akbez, rec.refaknr, rec.me, rec.ld_eklos, rec.ld_an_nr, rec.versart, 
        COALESCE(rec.ld_krzl, '#'), rec.w_l_krz, rec.w_l_krz, rec.w_lfsnr,
        uebernahme, rec.ld_a2_id, rec.w_q_nr, rec.ld_txtint, rec.ld_txtint_rtf, rec.ekp_mec
      ) RETURNING belp_id INTO posid;

      -- Wenn Kopftext Belegdokument noch leer ist, übernehmen wir den "Hinweistext zur Bestellung" aus ldsdoktxt
      IF COALESCE(rec.ldt_txt,'')<>'' THEN
        UPDATE belegdokument SET beld_kopftext = rec.ldt_txt WHERE beld_id = docRec.beld_id AND COALESCE(beld_kopftext,'')='';
       END IF;

      IF frei THEN
        --PERFORM TBeleg.BelegPosAbzuFromEpreis(rec.e_id, posid);
        PERFORM TWawi.Abzu_Copy('Epreis_Abzu', rec.e_id::VARCHAR,  'BelegPos_Abzu', posid::VARCHAR, uebernahme);
       ELSE
        --PERFORM TBeleg.BelegPosAbzuFromLdsdok(rec.ld_id, posid);
        PERFORM TWawi.Abzu_Copy('Ldsdok_Abzu', rec.ld_id::VARCHAR, 'BelegPos_Abzu', posid::VARCHAR, uebernahme);
       END IF;

      RETURN  posid;
     END $$ LANGUAGE plpgsql VOLATILE;
 --
 CREATE OR REPLACE FUNCTION TWawi.beleg_p__rechnunge__from__einkauf__create(IN ldsdokdbrid varchar, IN belegdoknr varchar(30), IN menge numeric) RETURNS integer AS $$
  DECLARE rec     record;
          docRec     record;
          belegid integer;
          posid   integer;
          uebernommen numeric;
          uebernahme  numeric;
          menge_gme numeric;
  BEGIN

   -- Wir sammeln mal alle möglichen Daten im System
   SELECT coalesce(ld_preis,0)                  AS preis,
          coalesce(NullIf(ld_preiseinheit,0),1) AS preiseinheit,
          ld_mce AS me,
          ld_ekp_mce AS pme,
          coalesce(ld_arab,0) AS rabatt,
          ld_bem AS refAknr,
          ltd_vers AS versart,
          ld_stk,ld_stk_uf1, ld_id, ld_auftg, ld_pos, ld_aknr,ld_kn, ld_krzf, ld_krzl, ld_waer, ltd_gesrab,ld_eklos,
          ld_an_nr, ld_lkontakt, ld_lkontaktkrzl, ld_kontakt, ld_krzl, ld_krzf, ltd_zakbem,
          ltd_apkrzl, ltd_ap, ltd_apint, a2_zahlart, m_uf,
          coalesce(ltd_zak, 0) AS zahlkond,
          coalesce(ltd_sks, 0) AS skontosatz,
          coalesce(ltd_skv, 0) AS skontotage,
          coalesce(ld_ks, ak_ks, ac_ks) AS ks,
          coalesce(ld_konto, ak_awko, ac_konto) AS konto,
          coalesce(ld_akbz,ak_bez) AS akbez,
          steu_z AS steucode,
          steu_proz AS steuproz,
          coalesce(ld_kurs,wa_kurs,1) AS wakurs,
          ak_canRabatt, ain_canSkonto,
          ld_a2_id,
          ld_q_nr,
          ldt_txt, ld_txtint, ld_txtint_rtf --Einkaufstexte durchreichen
          INTO rec
          FROM ldsdok    JOIN art ON ld_aknr = ak_nr
                         JOIN artcod ON ak_ac = ac_n
                         JOIN artmgc ON ld_mce = m_id
                         JOIN adk ON ad_krz = ld_kn
                         LEFT JOIN adk2 ON ad_krz = a2_krz
                         --LEFT JOIN ab2  ON a2_id  = ld_a2_id TODO.
                         --LEFT JOIN op2  ON a2_o2_id = o2_id
                         LEFT JOIN ldsdokdokutxt ON ld_dokunr = ltd_dokunr
                         LEFT JOIN ldsdoktxt     ON ldt_code = ld_code AND ldt_auftg = ld_auftg -- Zusatztext zur Bestellung kommt daher.
                         LEFT JOIN artinfo ON ain_ak_nr = ak_nr
                         LEFT JOIN bewa ON wa_einh = ld_waer
                         CROSS JOIN LATERAL steutxt__steu_z__valid_follower_get( coalesce(ld_steucode, ain_steucode_ek, a2_wuco,TSystem.Settings__GetInteger('einksteucode')) )
          WHERE ldsdok.dbrid = ldsdokdbrid;
   --
   SELECT * INTO docRec FROM eingrechdokument WHERE beld_dokunr = belegdoknr;

   -- Übernommen in GME
   SELECT SUM(belp_menge_gme) INTO uebernommen FROM eingrech_pos WHERE belp_ld_id = rec.ld_id;
   --Zu übernehmende Menge in GME
   menge_gme:=menge / Ifthen(rec.m_uf=0,1,rec.m_uf);

   --Keine zu übernehmende Menge angegeben? Ausrechnen was noch offen ist und alles übernehmen.
   IF (menge IS NULL) THEN
     --Uebernahme ist in ME des Wareneingangs
     uebernahme:=( rec.ld_stk * (1-coalesce(uebernommen,0) / IfThen(rec.ld_stk_uf1 = 0, 1, rec.ld_stk_uf1)));
   ELSE
     --Wenn mehr übernommen werden soll als zugegangen abzgl. schon uebernommen, auf Restbestand zurücksetzen
     IF ((menge_gme + uebernommen) > rec.ld_stk_uf1) THEN
       uebernahme:=(rec.ld_stk_uf1 - uebernommen)*Ifthen(rec.m_uf=0,1,rec.m_uf);
     ELSE
       uebernahme:=menge;
     END IF;
   END IF;

   IF (uebernahme < 0) THEN
     uebernahme:=0;
   END IF;

   --Belegposition mitnehmen
   INSERT INTO eingrech_pos (
     belp_dokument_id, belp_ld_id,
     belp_skontofaehig, belp_rabattfaehig, belp_konto, belp_kostenstelle, belp_kurs,
     belp_waehr, belp_steucode, belp_steuproz, belp_preis, belp_preiseinheit, belp_rabatt,
     belp_aknr, belp_akbez, belp_referenzaknr, belp_mce, belp_preis_mce, belp_los, belp_projektnummer,
     belp_versandartbem, belp_krzbesteller, belp_krzlieferung, belp_krzrechnung, belp_referenz,
     belp_menge, belp_a2_id, belp_q_nr, belp_txt, belp_txt_rtf
   ) VALUES (
     docRec.beld_id, rec.ld_id,
     coalesce(rec.ain_canSkonto,TRUE), rec.ak_canRabatt, rec.konto, rec.ks, rec.wakurs,
     rec.ld_waer, rec.steucode, rec.steuproz, rec.preis, rec.preiseinheit, rec.rabatt,
     rec.ld_aknr, rec.akbez, rec.refaknr, rec.me, rec.pme, rec.ld_eklos, rec.ld_an_nr,
     rec.versart, rec.ld_krzl, rec.ld_kn, rec.ld_kn, rec.ld_auftg||'/'||rec.ld_pos,
     uebernahme, rec.ld_a2_id, rec.ld_q_nr, rec.ld_txtint, rec.ld_txtint_rtf
   ) RETURNING belp_id INTO posid;

   -- Wenn Kopftext Belegdokument noch leer ist, übernehmen wir den "Hinweistext zur Bestellung" aus ldsdoktxt
   IF coalesce(rec.ldt_txt,'')<>'' THEN
     UPDATE belegdokument SET beld_kopftext = rec.ldt_txt WHERE beld_id = docRec.beld_id AND coalesce(beld_kopftext,'')='';
   END IF;

   --PERFORM TBeleg.BelegPosAbzuFromLdsdok(rec.ld_id, posid);
   PERFORM TWawi.Abzu_Copy('Ldsdok_Abzu', rec.ld_id::varchar, 'BelegPos_Abzu', posid::varchar, uebernahme);

   RETURN  posid;
  END $$ LANGUAGE plpgsql VOLATILE;
 --
--


CREATE OR REPLACE FUNCTION twawi.rechnung_pos__p_id__wert_relevant__hauptpos_subpos__get( _p_dokunr varchar ) RETURNS integer[]
AS $$

  -- Funktion zur Ermittlung von Rechnungspositionen, welche für die Errechenung des Gesamtbetrags relevant sind

  WITH RECURSIVE

    ag AS (
        SELECT ag_id, ag_nr, ag_pos, ag_hpos, ag_vkptotalpos
        FROM auftg
        JOIN twawi.rechnung_posext ON
                p_vorgaenger_table = 'auftg'
            AND p_dokunr = _p_dokunr
            AND ag_id = p_vorgaenger_id
      ),

    ag_parent AS (
        SELECT * FROM ag WHERE ag_hpos IS null

        UNION

        SELECT ag.* FROM ag
        JOIN ag_parent ON ag.ag_hpos = ag_parent.ag_pos
        WHERE NOT ag_parent.ag_vkptotalpos
      )

    SELECT array(
        SELECT bz_id
        FROM belzeil_grund
        JOIN ag_parent ON ag_nr = bz_auftg AND ag_pos = bz_auftgpos
    );

$$ LANGUAGE sql STABLE;

--
-- ALTE FUNKTIONEN ÜBERSCHREIBEN
/* TODO > UPDATE; GIT: (Branch) auskommentiert -> aktiv. SVN -> inaktiv

CREATE OR REPLACE FUNCTION TBeleg.GetDokumentNr(IN beldid INTEGER) RETURNS VARCHAR AS $$
   SELECT TSystem_Wawi.beleg_k__k_nummer__from__k_id(beldid);
 $$ LANGUAGE SQL STABLE;

CREATE OR REPLACE FUNCTION TBeleg.GetDokumentNrFromPos(IN belpid INTEGER) RETURNS VARCHAR AS $$
 SELECT TSystem_Wawi.beleg_k__k_nummer__from__p_id(belpid);
 $$ LANGUAGE SQL STABLE;

CREATE OR REPLACE FUNCTION TBeleg.GetPosNummer(IN belpid INTEGER) RETURNS INTEGER AS $$
 SELECT TSystem_Wawi.beleg_p__p_pos__from__p_id(belpid);
 $$ LANGUAGE SQL STABLE;

CREATE OR REPLACE FUNCTION TBeleg.GetDokumentNrAndDatumFromPos(IN belpid INTEGER, OUT dokunr VARCHAR, OUT erstelldatum DATE) RETURNS RECORD AS $$
 SELECT dokunr, erstelldatum FROM TSystem_Wawi.beleg_k__k_nummer__erstelldatum__from__p_id(belpid) -- INTO dokunr, erstelldatum
 $$ LANGUAGE SQL STABLE;

--

-- LieferscheinV
 CREATE OR REPLACE FUNCTION TBeleg.LFS_Update_Auftg(IN agid INTEGER) RETURNS VOID AS $$
  SELECT NULL::void FROM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(agid);
  $$ LANGUAGE SQL;

 CREATE OR REPLACE FUNCTION TBeleg.LiefDokFromLagAb(IN lifschdbrid VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_k__lieferscheinv__from__lagerabgang__create(lifschdbrid, belegdoknr);
  $$ LANGUAGE SQL;

 CREATE OR REPLACE FUNCTION TBeleg.LiefPosFromLagAb(IN lifschdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_p__lieferscheinv__from__lagerabgang__create(lifschdbrid, belegdoknr, menge)
  $$ LANGUAGE SQL;
 CREATE OR REPLACE FUNCTION TBeleg.LiefDokFromAuftg(IN auftgdbrid VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_k__lieferscheinv__from__verkauf_p__create(auftgdbrid, belegdoknr);
  $$ LANGUAGE SQL;
 CREATE OR REPLACE FUNCTION TBeleg.LiefPosFromAuftg(IN Auftgdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_p__lieferscheinv__from__verkauf_p__create(Auftgdbrid, belegdoknr, menge);
  $$ LANGUAGE SQL;


-- RechnungE
 CREATE OR REPLACE FUNCTION TBeleg.EingrechDokumentFromADK2(IN adkrz VARCHAR, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_k__rechnunge__from__adk2__create(adkrz, belegdoknr);
  $$ LANGUAGE SQL;

 CREATE OR REPLACE FUNCTION TBeleg.EingrechDokumentFromWendat(IN wendatdbrid INTEGER, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_k__rechnunge__from__adk2__wendat__create(wendatdbrid, belegdoknr);
  $$ LANGUAGE SQL;
 CREATE OR REPLACE FUNCTION TBeleg.BelegPosFromWendatPos(IN belegtyp VARCHAR(3), IN wendatdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_p__rechnunge__from__wendat__create(wendatdbrid, belegdoknr, menge);
  $$ LANGUAGE SQL;

 CREATE OR REPLACE FUNCTION TBeleg.EingrechDokumentFromLdsdok(IN ldsdokdbrid INTEGER, IN belegdoknr VARCHAR(30)) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_k__rechnunge__from__adk2__einkauf__create(ldsdokdbrid, belegdoknr);
  $$ LANGUAGE SQL;
 CREATE OR REPLACE FUNCTION TBeleg.BelegPosFromLdsDok(IN belegtyp VARCHAR(3), IN ldsdokdbrid VARCHAR, IN belegdoknr VARCHAR(30), IN menge NUMERIC) RETURNS INTEGER AS $$
  SELECT TWawi.beleg_p__rechnunge__from__einkauf__create(ldsdokdbrid, belegdoknr, menge);
  $$ LANGUAGE SQL;

 -- Total Drop TODO aus Oberflächen/Delphi raus
 CREATE OR REPLACE FUNCTION TBeleg.Update_DokumentSumme(IN beldokid INTEGER) RETURNS VOID AS $$
   ;
  $$ LANGUAGE SQL;
--

-- RechnungV
 CREATE OR REPLACE FUNCTION tfaktura.belzeil__from_lifsch__create(bebnr VARCHAR, lifschdokunr VARCHAR, belpid INTEGER, lifschmenge NUMERIC DEFAULT NULL) RETURNS VOID AS $$
  SELECT TWawi.beleg_p__rechnungv__from__lieferscheinv_p__create(bebnr, lifschdokunr, belpid, lifschmenge);
  $$ LANGUAGE SQL;

 CREATE OR REPLACE FUNCTION tfaktura.belzeil__from_auftg__create(bebnr VARCHAR, auftgdokunr INTEGER, agid INTEGER ) RETURNS VOID AS $$
  SELECT TWawi.beleg_p__rechnungv__from__verkauf_p__create(bebnr, auftgdokunr, agid);
  $$ LANGUAGE SQL;
 --
 -- TODO Mehrsprachigkeit
 CREATE OR REPLACE FUNCTION z_99_deprecated.lang_belart(baid INTEGER, lang VARCHAR DEFAULT prodat_languages.curr_lang()) RETURNS VARCHAR(100) AS $$
     SELECT COALESCE(kba_bez, NULL) FROM TSystem_Wawi.beleg_k__belart WHERE kba_key = baid AND kba_tablename = 'rechnugnv'; -- JOIN lang
   $$ LANGUAGE sql STABLE;
 --
 CREATE OR REPLACE FUNCTION z_99_deprecated.lang_belart(baid VARCHAR, lang VARCHAR DEFAULT prodat_languages.curr_lang()) RETURNS VARCHAR(100) AS $$
     SELECT z_99_deprecated.lang_belart(AsNumeric(baid)::INTEGER, lang);
   $$ LANGUAGE sql STABLE;
 --
 CREATE OR REPLACE FUNCTION z_99_deprecated.lang_belegart(baid INTEGER, lang VARCHAR DEFAULT prodat_languages.curr_lang()) RETURNS VARCHAR(100) AS $$
     SELECT z_99_deprecated.lang_belart(baid, lang);
   $$ LANGUAGE sql STABLE;
--

--*/
